﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Reflection;
using System.Diagnostics;

namespace ZabezpieczNumeremSeryjnym
{
   class Program
   {

      /// <summary>
      /// Prosta funkcja wyszukująca wystąpienia tablicy bajtów wewnątrz innej tablicy. Dla wiekszych projektów można użyć szybszego algorytmu Boyer-Moore-Horspool
      /// </summary>
      /// <param name="aBufor">Tablica bajtów, w której szukamy</param>
      /// <param name="aSzukane">Szukana tablica bajtów</param>
      /// <returns></returns>
      static private int Szukaj(byte[] aBufor, byte[] aSzukane)
      {
         int indeks = -1;
         for (int i = 0; i < aBufor.Length - aSzukane.Length && indeks == -1; i++)
         {
            int j = 0;
            while (j < aSzukane.Length && aBufor[i + j] == aSzukane[j]) j++;
            if (j == aSzukane.Length)
               indeks = i;
         }
         return indeks;
      }

      /// <summary>
      /// Główna funkcja programu podmieniająca wzorzec
      /// </summary>
      static void ZmodyfikujPlik(string aPlikZabezpieczany, string aPlikZKluczemProgramowym, string aNumerSeryjny)
      {
         //Warto pamiętać, że obecnie bierzemy klucz podany wprost przez użytkownika, zamiast tego klucz powinien zawierać np. szestnastkowe kody ASCII
         //bajtów prawdziwego klucza. Można to zrobić inaczej, ale warto zapewnić aby klucz mógł zawierać wartości od 0 do 255 a nie tylko wąski wycinek,
         //inaczej będzie dużo łatwiejszy do złamania.
         byte[] numerSeryjnyJakoBajty = System.Text.Encoding.ASCII.GetBytes(aNumerSeryjny);

         // odczyt pliku zabezpieczanego
         System.IO.FileInfo fi = new System.IO.FileInfo(aPlikZabezpieczany);
         long rozmiar = fi.Length;
         byte[] zawartoscPliku = new byte[rozmiar];
         FileStream fs = File.OpenRead(aPlikZabezpieczany);
         BinaryReader reader = new BinaryReader(fs);
         zawartoscPliku = reader.ReadBytes((int)rozmiar);
         reader.Close();
         fs.Close();

         // odczyt pliku z zawartością metody
         fi = new System.IO.FileInfo(aPlikZKluczemProgramowym);
         rozmiar = fi.Length;
         byte[] zabezpieczanyKod = new byte[rozmiar];
         Debug.Assert(rozmiar > 8, "Długość zabezpieczanego kodu musi wynosić conajmniej 8 bajtów");

         fs = File.OpenRead(aPlikZKluczemProgramowym);
         reader = new BinaryReader(fs);
         zabezpieczanyKod = reader.ReadBytes((int)rozmiar);
         reader.Close();
         fs.Close();

         byte[] zabezpieczanyKodZaszfrowany = new byte[zabezpieczanyKod.Length];

         //szyfrowanie zawartości kluczem
         int indeksNumeruSeryjnego = 0;
         for (int i = 0; i < zabezpieczanyKod.Length; i++)
         {
            zabezpieczanyKodZaszfrowany[i] = (byte)(zabezpieczanyKod[i] ^ numerSeryjnyJakoBajty[indeksNumeruSeryjnego++]);
            if (indeksNumeruSeryjnego >= numerSeryjnyJakoBajty.Length)
               indeksNumeruSeryjnego = 0;
         }

         // modyfikacja zawartości
         // szukamy wystąpienia ciągu instrukcji odczytanych jako kod metody, zastąpimy je kodem po zaszyfrowaniu
         int znaleziony = Szukaj(zawartoscPliku, zabezpieczanyKod);
         while (znaleziony != -1)
         {
            for (int i = znaleziony; i < znaleziony + zabezpieczanyKod.Length; i++)
               zawartoscPliku[i] = zabezpieczanyKodZaszfrowany[i - znaleziony];
            znaleziony = Szukaj(zawartoscPliku, zabezpieczanyKod);
         }

         // zapis pliku
         FileStream fsw = File.OpenWrite(aPlikZabezpieczany);
         BinaryWriter writer = new BinaryWriter(fsw);
         writer.Write(zawartoscPliku);
         writer.Close();
         fsw.Close();

         Console.WriteLine(aPlikZabezpieczany + " został zmodyfikowany.");
      }

      static void Main(string[] args)
      {
         if (args.Length < 3)
         {
            Console.WriteLine("Prawidłowe wywołanie: CreateProgramKey.exe input_file_path key_file_path serial_number.");
            Console.WriteLine("  input_file_path - ścieżka do zabezpieczanego pliku.");
            Console.WriteLine("  secured_code_path - ścieżka do pliku z zabezpieczanym kodem.");
            Console.WriteLine("  serial_number - klucz zabezpieczający.");
         }
         else if (!File.Exists(args[0]))
            Console.WriteLine("Podany plik nie istnieje.");
         else ZmodyfikujPlik(args[0], args[1], args[2]);
      }
   }

}
